// Shader that shows normals by daxnitro.

uniform int fogMode;

varying vec4 vertColor;

const int GL_LINEAR = 9729;
const int GL_EXP = 2048;

void main() {
    gl_FragColor = vertColor;
    
	if (fogMode == GL_EXP) {
		gl_FragColor = mix(gl_FragColor, gl_Fog.color, 1.0 - clamp(exp(-gl_Fog.density * gl_FogFragCoord), 0.0, 1.0));
	} else if (fogMode == GL_LINEAR) {
		gl_FragColor = mix(gl_FragColor, gl_Fog.color, clamp((gl_FogFragCoord - gl_Fog.start) * gl_Fog.scale, 0.0, 1.0));
	}
}
